#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
using namespace std;

struct Vektor
{
    double ugao;
    double x;
    double y;
    int indeks;   
};

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    const double PI = acos(-1.0);

    vector<Vektor> vektori(n);

    for(int i = 0; i < n; i++){
        double x, y;
        cin >> x >> y;

        double ugao = atan2(y, x);   
        if(ugao < 0.0){
            ugao += 2.0 * PI;      
        }

        vektori[i].ugao  = ugao;
        vektori[i].x     = x;
        vektori[i].y     = y;
        vektori[i].indeks = i;      
    }

    sort(vektori.begin(), vektori.end(), [](const Vektor &a, const Vektor &b){
        return a.ugao < b.ugao;
    });

    vector<Vektor> prosireni(2 * n);
    for(int i = 0; i < n; i++){
        prosireni[i] = vektori[i];        
        prosireni[i + n] = vektori[i];     
        prosireni[i + n].ugao += 2.0 * PI; 
    }

    double najbolja_duzina2 = 0.0;
    double zbir_x = 0.0, zbir_y = 0.0;
    int desni = 0;
    int najbolji_i = 0, najbolji_j = 0;

    for(int levi = 0; levi < n; levi++){
        while(desni < levi + n and prosireni[desni].ugao - prosireni[levi].ugao < PI) {
            zbir_x += prosireni[desni].x;
            zbir_y += prosireni[desni].y;
            desni++;
        }

        double duzina2 = zbir_x * zbir_x + zbir_y * zbir_y;
        if(duzina2 > najbolja_duzina2){
            najbolja_duzina2 = duzina2;
            najbolji_i = levi;
            najbolji_j = desni;
        }

        zbir_x -= prosireni[levi].x;
        zbir_y -= prosireni[levi].y;
    }

    vector<int> izabrani;
    for(int k = najbolji_i; k < najbolji_j; k++){
        izabrani.push_back(prosireni[k].indeks);
    }
    
    sort(izabrani.begin(), izabrani.end());
    
    cout << izabrani.size() << "\n";
    for(size_t i = 0; i < izabrani.size(); i++){
        cout << izabrani[i]+1 << ' ';
    }

    return 0;
}